(*| 13:26  7/06/1996 *)
PROGRAM DIS8051;

USES Crt,StdTypes,DisUtils;

TYPE
  FullCodeType = String[24];

CONST
  MaxNewLineCode = 11;
  NewLineCodes : ARRAY[0..MaxNewLineCode] OF Integer =
   ($001,$002,$021,$022,$032,$041,$061,$080,$081,$0A1,$0C1,$0E1);


  FullRegCodes : ARRAY[0..$F] OF FullCodeType =
   ('INC     R0',  'DEC     R0',  'ADD     A,R0','ADDC    A,R0',
    'ORL     A,R0','ANL     A,R0','XRL     A,R0','MOV     R0,#',
    'MOV     ,R0', 'SUBB    A,R0','MOV     R0,', 'CJNE    R0,#',
    'XCH     A,R0','DJNZ    R0,', 'MOV     A,R0','MOV     R0,A');


  FullOrdCodes : ARRAY[0..15,0..4] OF FullCodeType =
   ({0x}('NOP',
         'AJMP    ',
         'LJMP    ',
         'RR      A',
         'INC     A'),
    {1x}('JBC     ',
         'ACALL   ',
         'LCALL   ',
         'RRC     A',
         'DEC     A'),
    {2x}('JB      ',
         'AJMP    ',
         'RET',
         'RL      A',
         'ADD     A,#'),
    {3x}('JNB     ',
         'ACALL   ',
         'RETI',
         'RLC     A',
         'ADDC    A,#'),
    {4x}('JC      ',
         'AJMP    ',
         'ORL     ,A',
         'ORL     ',
         'ORL     A,#'),
    {5x}('JNC     ',
         'ACALL   ',
         'ANL     ,A',
         'ANL     ',
         'ANL     A,#'),
    {6x}('JZ      ',
         'AJMP    ',
         'XRL     ,A',
         'XRL     ',
         'XRL     A,#'),
    {7x}('JNZ     ',
         'ACALL   ',
         'ORL     C,',
         'JMP     @A+DPTR',
         'MOV     A,#'),
    {8x}('SJMP    ',
         'AJMP    ',
         'ANL     C,',
         'MOVC    A,@A+PC',
         'DIV     AB'),
    {9x}('MOV     DPTR,#',
         'ACALL   ',
         'MOV     ,C',
         'MOVC    A,@A+DPTR',
         'SUBB    A,#'),
    {Ax}('ORL     C,/',
         'AJMP    ',
         'MOV     C,',
         'INC     DPTR',
         'MUL     AB'),
    {Bx}('ANL     C,/',
         'ACALL   ',
         'CPL     ',
         'CPL     C',
         'CJNE    A,#'),
    {Cx}('PUSH    ',
         'AJMP    ',
         'CLR     ',
         'CLR     C',
         'SWAP    A'),
    {Dx}('POP     ',
         'ACALL   ',
         'SETB    ',
         'SETB    C',
         'DA      A'),
    {Ex}('MOVX    A,@DPTR',
         'AJMP    ',
         'MOVX    A,@R0',
         'MOVX    A,@R1',
         'CLR     A'),
    {Fx}('MOVX    @DPTR,A',
         'ACALL   ',
         'MOVX    @R0,A',
         'MOVX    @R1,A',
         'CPL     A'));

FUNCTION BlankLineNeeded(OpCode: Byte): Boolean;
VAR
  I: Integer;
  B: Boolean;
BEGIN
  B:=False;
  FOR I:=0 TO MaxNewLineCode DO
    IF NewLineCodes[I]=OpCode THEN
      B:=True;
  BlankLineNeeded:=B;
END;  { BlankLineNeeded }

PROCEDURE ProcessData(Pass: Integer);
VAR
  ThisData:Word;
  I,DataBytes,BytesOnLine: Integer;
  InAscii,ExitLoop: Boolean;
BEGIN
  NeedBlankLine:=False;
  DataBytes:=1;
  IF NOT (Style IN [WordStyle]) THEN
    OpCodeString:='DB     '
  ELSE BEGIN
    OpCodeString:='DW     ';
    DataBytes:=2;
  END;
  BytesOnLine:=0;
  InAscii:=False;
  ExitLoop:=False;
  REPEAT
    ThisData:=0;
    FOR I:=1 TO DataBytes DO
      ThisData:=ThisData * 256 + GetNextByte;
    IF (Style=TableStyle) AND (Pass <> 2) THEN
      AddLabel(ThisData  + (CurrentAddress AND $F00),Location);
    IF Style=TableStyle THEN
      OpCodeString:=OpCodeString + 'L'
                 + HexString(ThisData + (CurrentAddress AND $F00),4) + ','
    ELSE IF ((ThisData <> $27) AND (ThisData >= $20)
                               AND (ThisData < $7B)) THEN BEGIN
      IF NOT InAscii THEN
        OpCodeString:=OpCodeString + #$27 + CHR(ThisData) + #$27 + ','
      ELSE BEGIN
        DELETE(OpCodeString,Length(OpCodeString)-1,2);
        OpCodeString:=OpCodeString + CHR(ThisData) + #$27 + ','
      END;
      InAscii:=True;
    END ELSE BEGIN
      OpCodeString:=OpCodeString + '0' + HexString(ThisData,2*DataBytes)
                                 + 'H,';
      InAscii:=False;
    END;
    INC(BytesOnLine);
    IF (BytesOnLine=ByteWidth) OR (CurrentAddress=SeqValue) THEN
      ExitLoop:=True;
    IF (Pass = 2) AND (CurrentAddress=NextLabelValue) THEN
      ExitLoop:=True;
  UNTIL ExitLoop;
  DELETE(OpCodeString,Length(OpCodeString),1);
END;

PROCEDURE ProcessOpCode(Pass:Integer);
VAR
  DataByte,ThisByte,LoByte,MidByte,HiByte,RelByte: Byte;
  ThisData: Word;
  DataN: ARRAY [1..3] OF Byte;
  I: Integer;
  MidString,EndString: LineString;
  DualData,BitOp: Boolean;

  FUNCTION RegByteName(B: Byte): STRING;
  CONST
    LoBits = '020H.0';
    Hex : ARRAY[0..15] OF CHAR = '0123456789ABCDEF';
  BEGIN
    IF BitOp THEN
      CASE B OF
        $88 : RegByteName:='IT0';       { TCON }
        $89 : RegByteName:='IE0';
        $8A : RegByteName:='IT1';
        $8B : RegByteName:='IE1';
        $8C : RegByteName:='TR0';
        $8D : RegByteName:='TF0';
        $8E : RegByteName:='TR1';
        $8F : RegByteName:='TF1';
        $98 : RegByteName:='RI';        { SCON }
        $99 : RegByteName:='TI';
        $9A : RegByteName:='RB8';
        $9B : RegByteName:='TB8';
        $9C : RegByteName:='REN';
        $9D : RegByteName:='SM2';
        $9E : RegByteName:='SM1';
        $9F : RegByteName:='SM0';
        $A8 : RegByteName:='EX0';       { IE }
        $A9 : RegByteName:='ET0';
        $AA : RegByteName:='EX1';
        $AB : RegByteName:='ET1';
        $AC : RegByteName:='ES';
        $AF : RegByteName:='EA';
        $B0 : RegByteName:='RXD';       { P3 }
        $B1 : RegByteName:='TXD';
        $B2 : RegByteName:='INT0';
        $B3 : RegByteName:='INT1';
        $B4 : RegByteName:='T0';
        $B5 : RegByteName:='T1';
        $B6 : RegByteName:='WR';
        $B7 : RegByteName:='RD';
        $B8 : RegByteName:='PX0';       { IP }
        $B9 : RegByteName:='PT0';
        $BA : RegByteName:='PX1';
        $BB : RegByteName:='PT1';
        $BC : RegByteName:='PS';
        $D0 : RegByteName:='P';         { PSW }
        $D2 : RegByteName:='OV';
        $D3 : RegByteName:='RS0';
        $D4 : RegByteName:='RS1';
        $D5 : RegByteName:='F0';
        $D6 : RegByteName:='AC';
        $D7 : RegByteName:='CY';
      ELSE IF B < $80 THEN BEGIN
        RegByteName:=LoBits;
        RegByteName[3]:=Hex[B SHR 3];
        RegByteName[6]:=Hex[B AND 7];
      END ELSE
        RegByteName:='0'+HexString(B,2)+'H';
      END
    ELSE CASE B OF
      $80 : RegByteName:='P0';
      $81 : RegByteName:='SP';
      $82 : RegByteName:='DPL';
      $83 : RegByteName:='DPH';
      $87 : RegByteName:='PCON';
      $88 : RegByteName:='TCON';
      $89 : RegByteName:='TMOD';
      $8A : RegByteName:='TL0';
      $8B : RegByteName:='TL1';
      $8C : RegByteName:='TH0';
      $8D : RegByteName:='TH1';
      $90 : RegByteName:='P1';
      $98 : RegByteName:='SCON';
      $99 : RegByteName:='SBUF';
      $A0 : RegByteName:='P2';
      $A8 : RegByteName:='IE';
      $B0 : RegByteName:='P3';
      $B8 : RegByteName:='IP';
      $D0 : RegByteName:='PSW';
      $E0 : RegByteName:='ACC';
      $F0 : RegByteName:='B';
    ELSE
      RegByteName:='0'+HexString(B,2)+'H';
    END;
  END;

BEGIN
  ThisByte:=GetNextByte;
(*
  IF ThisByte = $D5 THEN BEGIN
    Writeln('Bug');
  END;
*)
  IF NOT NeedBlankLine THEN
    NeedBlankLine:=BlankLineNeeded(ThisByte);
  OpCodeString:='';
  MidString:='H,0';
  EndString:='';
  NumOfDataBytes:=0;
  OpCodeAddressMode:=Implied;
  DualData:=False;
  BitOp:=False;
  CASE ThisByte OF
    $75 : BEGIN
            OpCodeString:='MOV     ';
            DualData:=True;
            MidString:='H,#0';
            OpCodeAddressMode:=Immediate;
            NumOfDataBytes:=2;
          END;
    $85 : BEGIN
            OpCodeString:='MOV     ';
            DualData:=True;
            NumOfDataBytes:=2;
          END;
    $A5 : OpCodeString:='****';
    $D6 : OpCodeString:='XCHD    A,@R0';
    $D7 : OpCodeString:='XCHD    A,@R1';
  END;
  IF Length(OpCodeString) = 0 THEN BEGIN
    LoByte:=ThisByte AND $F;
    MidByte:=ThisByte AND $1F;
    HiByte:=(ThisByte AND $F0) SHR 4;
    IF (LoByte IN [0..4]) THEN BEGIN
      OpCodeString:=FullOrdCodes[HiByte,LoByte];
      CASE LoByte OF
        0 : BEGIN
              CASE HiByte OF
                0,$E,$F : NumOfDataBytes:=0;
                1,2,3 :   BEGIN
                            NumOfDataBytes:=2;
                            OpCodeAddressMode:=Relative;
                            DualData:=True;
                            BitOp:=True;
                          END;
                ELSE      BEGIN
                            NumOfDataBytes:=1;
                            IF HiByte > 9 THEN
                            ELSE
                              OpCodeAddressMode:=Relative;
                          END;
              END;
            END;
        1 : BEGIN
              NumOfDataBytes:=1;
              OpCodeAddressMode:=Page48;
            END;
        2 : CASE HiByte OF
              2,3,$E,$F : NumOfDataBytes:=0;
              0,1       : BEGIN
                            NumOfDataBytes:=2;
                            OpCodeAddressMode:=Direct;
                          END;
              ELSE        BEGIN
                            NumOfDataBytes:=1;
                            IF HiByte > 8 THEN
                              BitOp:=TRUE;
                          END;
            END;
        3 : CASE HiByte OF
              4,5,6 : BEGIN
                        NumOfDataBytes:=2;
                        DualData:=True;
                        OpCodeAddressMode:=Immediate;
                        MidString:=',#0';
                      END;
              ELSE    NumOfDataBytes:=0;
            END;
        4 : IF HiByte = $B THEN BEGIN
              NumOfDataBytes:=2;
              DualData:=True;
              OpCodeAddressMode:=Relative;
            END;
      END;
    END ELSE BEGIN                      {ThisByte > $x4}
      IF ThisByte = $F5 THEN BEGIN
        OpCodeString:='MOV     ,A';
        NumOfDataBytes:=1;
      END ELSE
        OpCodeString:=FullRegCodes[HiByte];
      IF Length(OpCodeString) > 0 THEN BEGIN
        CASE HiByte OF
          $8 : BEGIN
                 NumOfDataBytes:=1;
               END;
          $A : BEGIN
                 NumOfDataBytes:=1;
               END;
          $B : BEGIN
                 NumOfDataBytes:=2;
                 OpCodeAddressMode:=Relative;
                 IF LoByte = 5 THEN
                   OpCodeString:='CJNE    A,';
               END;
          $D : BEGIN
                 IF LoByte <> 5 THEN
                   NumOfDataBytes:=1
                 ELSE BEGIN
                   OpCodeString:='DJNZ    ';
                   NumOfDataBytes:=2;
                 END;
                 OpCodeAddressMode:=Relative;
               END;
        END;
        DualData:=(ThisByte IN [$75,$85,$B5..$BF,$D5]);
        I:=POS('R0',OpCodeString);
        IF I > 0 THEN BEGIN
          INC(I);
          IF LoByte > 7 THEN
            OpCodeString[I]:=CHR(ORD(OpCodeString[I])+ (LoByte AND 7));
          DEC(I);
          IF LoByte < 8 THEN BEGIN
            IF LoByte = 7 THEN
              OpCodeString[I+1]:='1';
            IF LoByte = 5 THEN BEGIN
              NumOfDataBytes:=1;
              DELETE(OpCodeString,I,2);
            END ELSE
              INSERT('@',OpCodeString,I);
          END;
        END;
      END;
    END;
    IF ((HiByte = 8) AND (LoByte > 5))
     OR (ThisByte IN [$42,$52,$62,$92,$F5]) THEN BEGIN
      I:=POS(',',OpCodeString);
      IF I > 0 THEN BEGIN
        EndString:=COPY(OpCodeString,I,10);
        DELETE(OpCodeString,I,10);
      END;
    END;
    IF OpCodeString[Length(OpCodeString)]='#' THEN BEGIN
      IF HiByte <> $B THEN BEGIN
        INC(NumOfDataBytes);
        OpCodeAddressMode:=Immediate;
        OpCodeString:=OpCodeString+'0';
      END;
    END;
  END;
  IF NumOfDataBytes > 0 THEN BEGIN
    ThisData:=0;
    FOR I:=1 TO NumOfDataBytes DO BEGIN
      DataByte:=GetNextByte;
      IF I < 4 THEN
        DataN[I]:=DataByte;
      ThisData:=(ThisData SHL 8) + DataByte;
    END;
    IF (OpCodeAddressMode = Page48) THEN
      ThisData:=ThisData + ((HiByte AND $E) SHL 7) + (CurrentAddress AND $F800)
    ELSE IF (OpCodeAddressMode = Relative) THEN BEGIN
      IF DualData THEN
        RelByte:=DataN[2]
      ELSE
        RelByte:=ThisData;
      IF RelByte AND $80 <> 0 THEN
        ThisData:=CurrentAddress + RelByte-$100
      ELSE
        ThisData:=CurrentAddress + RelByte;
    END;
    IF (Pass <> 2) THEN BEGIN
      IF (OpCodeAddressMode = Relative) THEN BEGIN
        AddLabel(ThisData,Location);
      END ELSE IF (OpCodeAddressMode = Direct) THEN BEGIN
        AddLabel(ThisData,Location);
      END ELSE IF (OpCodeAddressMode = Page48) THEN
        AddLabel(ThisData,Location)
    END;
    IF Pass <> 1 THEN BEGIN
      IF (OpCodeAddressMode = Page48) OR (OpCodeAddressMode = Direct)
       OR (OpCodeAddressMode = Relative) THEN BEGIN
        IF DualData THEN
          OpCodeString:=OpCodeString + RegByteName(DataN[1]) + ',';
        OpCodeString:=OpCodeString + 'L' + HexString(ThisData,4)
      END ELSE IF DualData THEN
        IF ThisByte = $85 THEN
          OpCodeString:=OpCodeString + RegByteName(DataN[2]) + ','
                                     + RegByteName(Datan[1])
        ELSE
          OpCodeString:=OpCodeString + RegByteName(DataN[1]) + ',#0'
                                     + HexString(Datan[2],2)
      ELSE IF (NumOfDataBytes = 1) AND (OpCodeAddressMode <> Immediate) THEN
        OpCodeString:=OpCodeString + RegByteName(DataN[1])
      ELSE
        OpCodeString:=OpCodeString + COPY(DataString,9,2*NumOfDataBytes);
      IF OpCodeAddressMode = Immediate THEN
        OpCodeString:=OpCodeString + 'H';
      OpCodeString:=OpCodeString+EndString;
    END;
  END;
END;  { ProcessOpCode }

PROCEDURE ProcessFile(Pass:Integer);
VAR
  I: Integer;
  FirstByte: Byte;
  ThisLine: LineString;
  LineNum: Integer;
BEGIN
  Writeln('Pass ',Pass);
  IF Pass <> 2 THEN
    HiLabel:=1;
  IF Pass <> 1 THEN BEGIN
    IF NOT QuietScreen THEN
      Writeln('':32,'ORG   ',HexString(StartAddress,4),'H');
    IF SaveToDisk THEN
      Writeln(AsmFile,'':8,'ORG   ',HexString(StartAddress,4),'H');
  END;
  Nextlabel:=1;
  NextLabelValue:=LongInt(Labels[1].Value);
  BufPtr:=ByteBuf;
  LineNum:=0;
  CurrentAddress:=StartAddress;
  EndOfByteFile:=False;
  NeedBlankLine:=False;
  Style:=CodeStyle;
  NextStyle:=CodeStyle;
  ByteWidth:=8;
  IF SeqExists THEN BEGIN
    Reset(SeqFile);
    NextSeq;
  END;
  REPEAT
    IF SeqExists AND (CurrentAddress >= SeqValue) THEN BEGIN
{                 AND (NOT EOF(SeqFile)) THEN BEGIN}
      DoBlankLine(LineNum);
      IF NextStyle = Remark THEN
        InsertRemark(LineNum)
      ELSE BEGIN
        Style:=NextStyle;
        ByteWidth:=NextByteWidth;
      END;
      NextSeq;
    END;
    IF Pass <> 1 THEN
      InsertLabel(LineNum);
    DataString:=HexString(CurrentAddress,4) + '  ';
    IF Style=CodeStyle THEN
      ProcessOpCode(Pass)
    ELSE
      ProcessData(Pass);
(*  IF Pass <> 2 THEN
      Writeln(DataString);*)
    IF Pass <> 1 THEN BEGIN
      ThisLine:=COPY(DataString + '        ',1,12) + '                    '
                                + OpCodeString;
      IF NOT QuietScreen THEN BEGIN
        Writeln(ThisLine);
        INC(LineNum);
      END;
      IF SaveToDisk THEN
        Writeln(AsmFile,'':8,OpCodeString);
      IF NeedBlankLine THEN BEGIN
        DoBlankLine(LineNum);
        NeedBlankLine:=False;
      END;
      IF LineNum > 20 THEN BEGIN
        IF NOT SaveToDisk THEN
          IF ReadKey=#$1B THEN BEGIN
            ShowLabels;
            HALT;
          END;
        LineNum:=0;
      END;
    END;
  UNTIL EndOfByteFile;
  IF Pass <> 2 THEN
    Writeln(HiLabel-1,' labels');
  IF Pass <> 1 THEN BEGIN
    IF NOT QuietScreen THEN
      Writeln('':32,'END');
    IF SaveToDisk THEN
      Writeln(AsmFile,'':8,'END');
  END;
  Writeln;
END;  { ProcessFile }

BEGIN
  StartAddress:=$0000;
  IF ParamCount > 0 THEN
    ByteFileName:=ParamStr(1)
  ELSE
    ByteFileName:='8051.BIN';
  OpenSeqFile;
  Write('Disassembler by B Whitnall, V1.2, June 1996  ');
  Writeln('; 8051 ',ByteFileName);
  Writeln;
  Write('Save to Disk, Y/N ? ');
  SaveToDisk:=(UpCase(ReadKey)='Y');
  Writeln;
  QuietScreen:=False;
  IF SaveToDisk THEN BEGIN
    Write('Quiet Screen, Y/N ? ');
    QuietScreen:=(UpCase(ReadKey)='Y');
    Writeln;
  END;
  Writeln;
  ReadFileToBuf;
  EndAddress:=StartAddress + ByteFileSize;
  IF SaveToDisk THEN
    OpenAsmFile;
  FOR Pass:=1 TO 2 DO
    ProcessFile(Pass);
  IF SeqExists THEN
    Close(SeqFile);
  IF SaveToDisk THEN
    Close(AsmFile);
END.
